@extends('layouts.app')

@section('content')

<h1 class="text-success">user index with view </h1>
<table class="table">
    <thead>
      <tr>
        <th scope="col">#</th>
        <th scope="col">name</th>
        <th scope="col">email</th>
        <th scope="col">rolse</th>
        <th scope="col">control</th>
      </tr>
    </thead>
    <tbody>
        @foreach ($users as $item)
        <tr>
        <th scope="row">{{ $item->id }}</th>
            <td>{{ $item->name }}</td>
            <td>{{ $item->email }}</td>
            <td>{{ implode(' - ',$item->roles()->get()->pluck('name')->toArray()) }}</td>
            <td>
              @can('edit-user')  
              <a href="{{route('admin.user.edit', $item->id)}}"><button type="button" class="btn btn-info">Edit</button></a>
              @endcan 
              <a href="{{route('admin.user.edit', $item->id)}}"><button type="button" class="btn btn-warning">Delete</button></a>
            </td>
          </tr>
        @endforeach
    </tbody>
  </table>


@endsection