<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class LoginController extends Controller
{
    public function index(Request $request)
    {
        if (auth()->attempt(['email' => $request->input('email'), 'password' => $request->input('password')])) {
            $user = auth()->user();
            $user->api_token = Str::random(60);
            $user->save();
            // $response = ["success" => true, 'user' => $user];
            return json_encode($user);
        } else {
            $response = ['error' => "اسم المستخدم أو كلمة مرور غير صحيحة"];
            return json_encode($response);
        }
    }

    public function logout()
    {
        if (auth()->user()) {
            $user = auth()->user();
            $user->api_token = null;
            $user->save();
            $response = ["success" => true, 'user' => "تم تسجيل الخروج بنجاح"];
            return json_encode($user);
        } else {
            $response = ["success" => false, 'error' => "لم تسجل الدخول من قبل"];
            return json_encode($response);
        }
    }
}
