@extends('layouts.app')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('Register') }}</div>

                <div class="card-body">
                    <form method="POST" action="{{ route('register') }}">
                        @csrf

                        <div class="form-group row">
                            
                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required autocomplete="name" autofocus>
                                
                                @error('name')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <label for="name" class="col-md-4 col-form-label text-md-right">{{ __('الاسم') }}</label>
                        </div>

                        <div class="form-group row">
                            
                            <div class="col-md-6">
                                <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">
                                
                                @error('email')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <label for="email" class="col-md-4 col-form-label text-md-right">{{ __('البريد الالكتروني') }}</label>
                        </div>

                        <div class="form-group row">
                            
                            <div class="col-md-6">
                                <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" required autocomplete="new-password">
                                
                                @error('password')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                                @enderror
                            </div>
                            <label for="password" class="col-md-4 col-form-label text-md-right">{{ __('كلمة السر') }}</label>
                        </div>

                        <div class="form-group row">
                            
                            <div class="col-md-6">
                                <input id="password-confirm" type="password" class="form-control" name="password_confirmation" required autocomplete="new-password">
                            </div>
                            <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('تأكيد كلمة السر') }}</label>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-6">
                                <select class="form-control" name="user_id">
                                    <?php foreach ($user as $item): ?>
                                    <option value="{{$item->userId}}">{{$item->firstname . " ". $item->lastname}}</option>
                                    <?php endforeach?>
                                </select>
                            </div>
                            <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('اسم المستخدم') }}</label>
                        </div>

                        <div class="form-group row">
                            <div class="col-md-6">
                                <select class="form-control" name="role">
                                    <?php foreach ($roles as $item): ?>
                                    <option value="{{$item->id}}">{{$item->name}}</option>
                                    <?php endforeach?>
                                </select>
                            </div>
                            <label for="password-confirm" class="col-md-4 col-form-label text-md-right">{{ __('الصلاحية') }}</label>
                        </div>
                        <div class="form-group row mb-0">
                            <div class="col-md-6 offset-md-4">
                                <button type="submit" class="btn btn-primary">
                                    {{ __('Register') }}
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
