'use strict';

var _require = require('../helpers/is'),
    isFunction = _require.isFunction;

module.exports = function search(valueOrFunction, strict) {
  var _this = this;

  var valueFn = valueOrFunction;

  if (isFunction(valueOrFunction)) {
    valueFn = this.items.find(function (value, key) {
      return valueOrFunction(value, key);
    });
  }

  var index = false;

  if (Array.isArray(this.items)) {
    var itemKey = this.items.filter(function (item) {
      if (strict === true) {
        return item === valueFn;
      }

      return item === Number(valueFn) || item === String(valueFn);
    })[0];

    index = this.items.indexOf(itemKey);
  } else {
    return Object.keys(this.items).filter(function (prop) {
      if (strict === true) {
        return _this.items[prop] === valueFn;
      }

      return _this.items[prop] === Number(valueFn) || _this.items[prop] === valueFn.toString();
    })[0] || false;
  }

  if (index === -1) {
    return false;
  }

  return index;
};