<?php

namespace App\Http\Controllers\Api;

use App\Amount;
use App\Http\Controllers\Controller;
use App\Suppler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SupplerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (auth()->user()) {
            $suppler = Suppler::where('user_id', auth()->user()->id)->get();
            $response = ["success" => true, 'suppler' => $suppler];
            return json_encode($response);
        } else {
            $response = ["success" => false, 'message' => "تم حظرك قم بتسجيل الدخول من جديد"];
            return json_encode($response);
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $suppler = Suppler::all();
        return json_encode($suppler);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'max:100'],
            'phone' => ['required']
        ]);

        if ($validator->fails()) {
            $response = ["success" => false, 'message' => $validator->errors()];
            return json_encode($response);
        } else {
            $suppler = Suppler::create([
                'name'  => $request->name,
                'phone' => $request->phone,
                'amont'  => 0,
                'user_id' => auth()->user()->id
            ]);
            $response = ["success" => true, 'suppler' => $suppler];
            return json_encode($response);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function amount(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'sup_id'     => ['required|numeric'],
            'deteles'    => ['required', 'max:100'],
            'amount_add' => ['required'],
            'type'       => ['required'],
           
        ]);

        if ($validator->fails()) {
            $response = ["success" => false, 'message' => $validator->errors()];
            return json_encode($response);
        } else {
            $sup = Suppler::find($request->sup_id);
            $amount = new Amount();
            $amount->sup_id  = $request->sup_id;
            $amount->deteles = $request->deteles;
            if ($request->type == 1) {
                $amount->amount_add = $request->amount_add;
                $amount->amount_teg = 0;
                $amont = $sup->amont + $request->amount_add;
            } else {
                $amount->amount_add = 0;
                $amount->amount_teg = $request->amount_add;
                $amont = $sup->amont - $request->amount_add;
            }
            $amount->all_amount = $amont;
            $amount->date = date("Y-m-d");
            $amount->user_id = auth()->user()->id;

            if ($amount->save()) {
                $sup->amont = $amont;
                $sup->save();
            }

            $response = ["success" => true, 'amount' => $sup];
            return json_encode($response);
        }
    }

    public function showamount(Request $request)
    {
        $suppler = Amount::where(['user_id' => auth()->user()->id, 'sup_id' => $request->sup_id])->get();
        $response = ["success" => true, 'suppler' => $suppler];
        return json_encode($response);
    }
    /**
     * Display the specified resource.
     *
     * @param  \App\Suppler  $suppler
     * @return \Illuminate\Http\Response
     */
    public function show(Suppler $suppler)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Suppler  $suppler
     * @return \Illuminate\Http\Response
     */
    public function edit(Suppler $suppler)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Suppler  $suppler
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Suppler $suppler)
    {
        $validator = Validator::make($request->all(), [
            'name' => ['required', 'max:100'],
            'phone' => ['required']
        ]);

        if ($validator->fails()) {
            $response = ["success" => false, 'message' =>$validator->errors()];
            return json_encode($response);
        } else {
            $suppler->name = $request->name;
            $suppler->phone =  $request->phone;
            $suppler->save();
            $response = ["success" => true, 'suppler' => $suppler];
            return json_encode($response);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Suppler  $suppler
     * @return \Illuminate\Http\Response
     */
    public function destroy(Suppler $suppler)
    {
        //
    }
}
