<?php

namespace App\Http\Controllers\Api;

use App\Amount;
use App\Http\Controllers\Controller;
use App\Order;
use App\Suppler;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;

class OrderController extends Controller
{

    public function index()
    {
        if (auth()->user()) {
            $orders = Order::where('user_id', auth()->user()->id)->get()->toJson();
            return $orders;
        } else {
            return "no data";
        }
    }

    public function show(Order $order)
    {
        $response = ["success" => true, 'order' => $order];
        return json_encode($response);
    }

    public function orders(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'amunt'   => ['required'],
            'Ingot'   => ['required'],
            'sample'  => ['required'],
            'Caliber' => ['required'],
            'teg'     => ['required']
        ]);

        if ($validator->fails()) {
            $response = ["success" => false, 'error' => $validator->errors()];
            return $response;
        } else {
            $Net_weight = $request->Ingot + $request->sample;
            $Net_caliber = ($Net_weight * $request->Caliber) / 875;
            $amount = ($Net_caliber * $request->amunt) - $request->teg;

            $order = new Order();

            $order->Ingot       = $request->Ingot;
            $order->Net_weight  = $Net_weight;
            $order->sample      = $request->sample;
            $order->Caliber     = $request->Caliber;
            $order->Net_caliber = $Net_caliber;
            $order->amunt       = $request->amunt;
            $order->teg         = $request->teg;
            $order->allamount   = $amount;
            $order->adate       = date("Y-m-d");
            $order->sup_id      = $request->sup_id;
            $order->user_id     = auth()->user()->id;

            if ($order->save()) {
                $sup = Suppler::find($request->sup_id);
                $amount = new Amount();
                $amount->sup_id  = $request->sup_id;
                $amount->deteles = "عبارة عن مبلغ فاتورة رقم $order->id ";
                $amount->amount_add = $request->amount_add;
                $amount->amount_teg = 0;
                $amont = $sup->amont + $amount;
                $amount->all_amount = $amont;
                $amount->date = date("Y-m-d");
                $amount->user_id = auth()->user()->id;
                $amount->save();
                $response = ["success" => true, 'order' => $order];
                return $response;
            } else {
                $response = ["success" => false, 'لم يتم الحفظ' => $order];
                return $response;
            }
        }
    }
}
