<?php

namespace App\Http\Controllers\Api;

use App\Advances;
use App\Employee;
use App\Expenses;
use App\ExpensesType;
use App\Http\Controllers\Controller;
use App\Office;
use App\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class ExpensesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $setting = Setting::all()->first();
        $exten = Expenses::join("app_Expenses_Type", "app_Expenses.ExpensesId", "app_Expenses_Type.Id")
            ->join("app_users_profiles", "app_Expenses.CreatedBy", "app_users_profiles.userId")
            ->where(["app_Expenses.stage" => $request->stage, "app_Expenses_Type.adate" => $setting->adate])
            ->select("app_Expenses.*", "app_Expenses_Type.Expenses", "app_users_profiles.firstname", "app_users_profiles.lastname")
            ->get()->tojson();
        return $exten;
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $exten = Expenses::where("stage", "new")->get()->toJson();
        return $exten;
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'ExpensesId'        => ['required'],
            'amuont'            => ['required'],
            'textamunt'         => ['required'],
            'Expenses_Data'     => ['required'],
            'beneficiary'       => ['required'],
            'officeId'            => ['required'],
        ]);

        if ($validator->fails()) {
            $response = ["success" => false, 'msg' => "تحقق من الادخال لو سمحت"];
            return $response;
        }
        $exType = ExpensesType::find($request->ExpensesId);
        $maxAmount = $exType->amuon;
        $minAmount = $exType->min_amuon + $request->amuont;

        if ($maxAmount >= $minAmount) {
            $expenses = new Expenses();

            $expenses->ExpensesId = $request->ExpensesId;
            $expenses->amuont = $request->amuont;
            $expenses->textamunt = $request->textamunt;
            $expenses->Expenses_Data = $request->Expenses_Data;
            $expenses->date = date('Y-m-d');
            $expenses->beneficiary = $request->beneficiary;
            $expenses->stage = 'new';
            $expenses->officeId = $request->officeId;
            $expenses->CreatedBy = auth()->user()->user_id;
            $expenses->uudatedBy = auth()->user()->user_id;

            if ($expenses->save()) {
                $response = ["success" => true, 'msg' => "تم العميلة بنجاح"];
                return $response;
            } else {
                $response = ["success" => false, 'msg' => "لم يتم حفظ المصروف"];
                return $response;
            }
        } else {
            $response = ["success" => false, 'msg' => "مبلغ الموازنة غير كافي"];
            return $response;
        }
        return $maxAmount;
    }

    public function expenseType()
    {
        $setting = Setting::all()->first();
        $exType = ExpensesType::where("adate", $setting->adate)->where("Id", "!=", $setting->salary)->get()->toJson();
        return $exType;
    }
    public function office()
    {
        return Office::all();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Expenses  $expenses
     * @return \Illuminate\Http\Response
     */
    public function show(Expenses $expenses)
    {
        $exten = Expenses::join("app_Expenses_Type", "app_Expenses.ExpensesId", "app_Expenses_Type.Id")
            ->join("app_users_profiles", "app_Expenses.CreatedBy", "app_users_profiles.userId")
            ->where("app_Expenses.Id", $expenses->Id)
            ->select("app_Expenses.*", "app_Expenses_Type.Expenses", "app_users_profiles.firstname", "app_users_profiles.lastname")
            ->get()->first();
        return $exten;
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Expenses  $expenses
     * @return \Illuminate\Http\Response
     */
    public function edit(Expenses $expenses)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Expenses  $expenses
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Expenses $expenses)
    {
        $validator = Validator::make($request->all(), [
            'amuont'            => ['required'],
            'textamunt'         => ['required'],
            'Expenses_Data'     => ['required'],
            'beneficiary'       => ['required'],
            'stage'             => ['required'],
        ]);

        if ($validator->fails()) {
            $response = ["success" => false, 'msg' => "تحقق من الادخال لو سمحت"];
            return $response;
        }
        $exType = ExpensesType::find($expenses->ExpensesId);
        $maxAmount = $exType->amuon;
        $minAmount = $exType->min_amuon + $request->amuont;

        //         echo "<br>";

        // return $exType;
        if ($maxAmount >= $minAmount) {
            $expenses->amuont = $request->amuont;
            $expenses->textamunt = $request->textamunt;
            $expenses->Expenses_Data = $request->Expenses_Data;
            $expenses->beneficiary = $request->beneficiary;
            $expenses->stage = $request->stage;
            $expenses->uudatedBy = auth()->user()->user_id;
            if ($expenses->save()) {
                if ($request->stage == "ok") {
                    $exType->min_amuon = $minAmount;
                    $exType->save();
                }
                $response = ["success" => true, 'msg' => "تم العميلة بنجاح"];
                return $response;
            } else {
                $response = ["success" => false, 'msg' => "لم يتم حفظ المصروف"];
                return $response;
            }
        } else {
            $response = ["success" => false, 'msg' => "مبلغ الموازنة غير كافي"];
            return $response;
        }
        return $maxAmount;
    }

    public function employee(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'empId'            => ['required'],
            'salary'           => ['required'],
            'amuont'           => ['required'],
            'textamunt'        => ['required'],
            'Expenses_Data'    => ['required'],
            'empName'      => ['required'],

        ]);

        if ($validator->fails()) {
            $response = ["success" => false, 'msg' => "تحقق من الادخال لو سمحت"];
            return $response;
        }
        $setting = Setting::all()->first();
        $exType = ExpensesType::where("adate", $setting->adate)->where("Id", $setting->salary)->get()->first();
        if (date('d') > 24) {
            return ["success" => false, 'msg' => "تفتح عهد المرتبات من يوم 1-24 من كل شهر"];
        }
        if (!isset($exType->Id) && $exType->Id > 1) {
            return ["success" => false, 'msg' => "لم يتم ضبط بند الرواتب الشهرية لهذه السنة"];
        }
        $data_a = date('Y-m');
        $salary = Advances::where("tdate", 'like', '%' . $data_a . '%')->where('EmpId', $request->empId)->sum("Amuont");

        if ((($salary + $request->amuont) + ($request->salary / 2)) <= $request->salary) {

            $advances = new Advances();

            $advances->EmpId = $request->empId;
            $advances->tdate = date('Y-m-d');
            $advances->Amuont = $request->amuont;
            $advances->hulla = "new";
            $advances->createdBy = auth()->user()->user_id;
            $advances->updatedBy = auth()->user()->user_id;

            $maxAmount = $exType->amuon;
            $minAmount = $exType->min_amuon + $request->amuont;

            if ($maxAmount >= $minAmount) {
                if ($advances->save()) {
                    $expenses = new Expenses();
                    $expenses->ExpensesId = $exType->Id;
                    $expenses->amuont = $request->amuont;
                    $expenses->textamunt = $request->textamunt;
                    $expenses->Expenses_Data = $request->Expenses_Data;
                    $expenses->date = date('Y-m-d');
                    $expenses->beneficiary = $request->empName;
                    $expenses->stage = 'new';
                    $expenses->officeId = 1;
                    $expenses->CreatedBy = auth()->user()->user_id;
                    $expenses->uudatedBy = auth()->user()->user_id;
                    if ($expenses->save()) {
                        $response = ["success" => true, 'msg' => "تم العميلة بنجاح"];
                        return $response;
                    } else {
                        $response = ["success" => false, 'msg' => "لم يتم حفظ العهدة مع خصم المبلغ من راتبك"];
                        return $response;
                    }
                } else {
                    $response = ["success" => false, 'msg' => "لم تنجح العملية حاول مرة اخرى"];
                    return $response;
                }
            } else {
                $response = ["success" => false, 'msg' => "مبلغ الموازنة غير كافي"];
                return $response;
            }
        } else {
            return ["success" => false, 'msg' => " تذكر ! يجب أن يكون في الحساب 50% من راتبك"];
        }

        return $salary;
    }

    public function employ()
    {
        return Employee::all();
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Expenses  $expenses
     * @return \Illuminate\Http\Response
     */
    public function destroy(Expenses $expenses)
    {
        //
    }
}
